#include "setup.h"

#define ROB						4
//#define HARDWARE				0x01
#define FIRMWARE_HIGH_NIB		0x00
//#define FIRMWARE_LOW_BYTE		0xFF	
#define FIRMWARE_LOW_BYTE		0x39	//firmware prints hex value _0.30
										//_ = Letter code for type of probe
										//A = pH Trac
										//B = pre term Birth
										//C = Cancer
										//D = Data Collection/Development (not yet used)
										//E = spErm
										//F = FertiliTrac (ABINGTON)

#define OFF						0x00
#define ON						0x01
#define SLEEP					0x00
#define IDLE_MINUTES			0x04
#define LOW_BATTERY				0x01
#define	BATTERY_OK				0x00
#define TRUE					1
#define FALSE					0
#define ERROR					0xA0
#define SET						0x01
#define SEND_DATA				0x01
#define IR_LMP_DATA				0x00

#ifdef ABINGTON
#define FIELDSIZE				0x0A
//#define TRIAL					0x0F
#define FIRMWARE_HIGH_BYTE		0xF0 | FIRMWARE_HIGH_NIB
#endif

#ifdef pH
#define FIELDSIZE				0x0A
//#define TRIAL					0x0F
#define FIRMWARE_HIGH_BYTE		0xA0 | FIRMWARE_HIGH_NIB
#endif

#ifdef FACTORYpH
#define FIELDSIZE				0x0A
//#define TRIAL					0x0F
#define FIRMWARE_HIGH_BYTE		0xD0 | FIRMWARE_HIGH_NIB
#endif

#ifdef TEMPLECANCER
#define FIELDSIZE				130		//10 + (10 x 2) + (10 x 2) + (10 x 2) + (30 x 2) = 130
//#define TRIAL					0x0C
#define FIRMWARE_HIGH_BYTE		0xC0 | FIRMWARE_HIGH_NIB
#endif

#ifdef TEMPLEPRETERM
#define FIELDSIZE				70
//#define TRIAL					0x0B
#define FIRMWARE_HIGH_BYTE		0xB0  | FIRMWARE_HIGH_NIB
#endif

#ifdef SPERM
#define FIELDSIZE				0x0A
//#define TRIAL					0x0E
#define FIRMWARE_HIGH_BYTE		0xE0 | FIRMWARE_HIGH_NIB
#endif

#define FIELDENDTODATE			0x09
#define FIELDENDTOYEAR			0x08
#define FIELDENDTOMONTH			0x08
#define FIELDENDTOMEASUREMENT	0x06
#define FIELDENDTOMEASLOWBYTE	0x06
#define FIELDENDTOMEASHIGHBYTE	0x05
#define FIELDENDTOTEMPERATURE	0x04
#define FIELDENDTOTEMPLOWBYTE	0x04
#define FIELDENDTOTEMPHIGHBYTE	0x03
#define FIELDENDTOpHWHOLE		0x00
#define FIELDENDTOpHTENTHS		0x02

#define FIELDSTARTTODATE		0x01
#define FIELDSTARTTOMONTH		0x02
#define FIELDSTARTTOYEAR		0x02
#define FIELDSTARTTOMEASLOWBYTE	0x04
#define FIELDSTARTTOMEASHIGHBYTE 0x05
#define FIELDSTARTTOTEMPLOWBYTE	0x06
#define FIELDSTARTTOTEMPHIGHBYTE 0x07
#define FIELDSTARTTOpHWHOLE		0x09
#define FIELDSTARTTOpHTENTHS	0x07

#define MONTHFROMMEASUREMENT	0x02
#define DATEFROMMEASUREMENT		0x03
#define YEARFROMMEASUREMENT		0x02

#define MONTHFROMpHMEASUREMENT 	0x07
#define DATEFROMpHMEASUREMENT	0x08
#define YEARFROMpHMEASUREMENT	0x07

#define CODEUPDATESTATUSINDEX	0x0017
#define CHECKSUMLOWBYTEINDEX	0x0018
#define CHECKSUMHIGHBYTEINDEX	0x0019
#define CODEUPDATESTATUS 		0x1000 + CODEUPDATESTATUSINDEX
#define CHECKSUMLOWBYTE 		0x1000 + 0x0018
#define CHECKSUMHIGHBYTE 		0x1000 + 0x0019
#define CODESTART 				0x1800
#define ROMSTART 				0x1100
#define SEGMENTSIZE 			512
#define MEMORYSIZE				4096	//bytes

//graphics.h
#define RD  					0x01
#define WR  					0x02
#define A0  					0x04
#define CSX 					0x08
#define RST 					0x10
#define COLUMN_MAX 				127
#define LINES_MAX 				3
#define DATA					1
#define COMMAND					0
#define HALT					4

//i2c.h
#define MEMORYMAX				0x0FFF
#define MEMORYSIZELIMITERROR	0
#define SUCCESS					1
#define	SDA						0x80
#define	SCL						0x40
#define ACK						0x00
#define NOACK					0x01
#define NAMESTART				0x06
#define NAMESIZE				20
#define PASSWORDSTART			0x1A
#define PASSWORDSIZE			20
#define FIRSTFIELDADDRESS		0x80
#define EEPROMRESERVEDSTART		0x7B
#define EEPROMRESERVEDSIZE		5
#define ESNSTARTADDRESS			0x2E
#define PERIODHEADER			0x007B
#define PERIODMONTH				0x007C
#define PERIODDAY				0x007D
#define PERIODYEAR				0x007E
#define pH_SDA 					0x40			// P5.6 
#define pH_SCL					0x20			// P5.5

//Status Icons
#define UPARROW					0x02
#define DOWNARROW				0x01
#define BOTHARROW				0x03

//UART.h
#define RS232					0x04
#define IrDA					0x02
#define IRDA					0x02
#define COMMANDERROR			0x0A
#define COMMANDACK				0xAA

//key.h
#define KEY_UP					0x02
#define KEY_DOWN				0x01
#define KEY_SEL					0x40


//measurement.h
#define	MEASUREMENT_MINIMUM		0x1014	//Must include lowest multiplier
#define FOUR_8KHz				0x0171
#define SIX_KHz					0x015A
#define EIGHT_KHz				0x00E7 
#define TenKHz					0x00b9 	//185 5KHz = 0x171 369
#define TEN_KHz					0x00b9
#define TWELVE_KHz				0x009a
#define MEASUREMENT_LOW_BATTERY	0x02
#define MILLIVOLTS				0x01
#define IMPEDANCE				0x00
#define pH43					1050	//641*1000/610	//1050
#define pH69					2597	//1584*1000/610	//2596.72
#define pH70					3078	//1875*1000/610	//3073.77
#define ADC_STEP				610		
#define pH_PROBE_DET			0x01

//utility.h
//delay timing for Utility Delay250ms
#define POINT_25_SECONDS		1
#define POINT_5_SECONDS			2
#define POINT_75_SECONDS		3
#define ONE_SECOND				(4*1)
#define TWO_SECONDS				(4*2)
#define THREE_SECONDS			(4*3)
#define FOUR_SECONDS			(4*4)
#define FIVE_SECONDS			(4*5)
#define SIX_SECONDS				(4*6)
#define SEVEN_SECONDS			(4*7)
#define EIGHT_SECONDS			(4*8)
#define NINE_SECONDS			(4*9)
#define TEN_SECONDS				(4*10)
#define ELEVEN_SECONDS			(4*11)
#define TWELVE_SECONDS			(4*12)
#define THIRTEEN_SECONDS		(4*13)
#define FOURTEEN_SECONDS		(4*14)
#define FIFTEEN_SECONDS			(4*15)
#define SIXTEEN_SECONDS			(4*16)
#define	SEVENTEEN_SECONDS		(4*17)
#define EIGHTEEN_SECONDS		(4*18)
#define NINETEEN_SECONDS		(4*19)
#define TWENTY_SECONDS			(4*20)
#define BUZZER 					0x40
#define FOUR_POINT_TWO_KHz		0x1B7
#define TWO_POINT_ONE_KHz		0x36E
#define ONE_POINT_ZERO_FIVE_KHz	0x6DB
#define POINT_525_KHz			0xDB7
#define THREE_KHz				0x266
#define ONE_POINT_FOUR_KHz		0x525
#define I2C						0x01
#define FIFTY_MS				0x00
#define ALARM_DELAY				0x02
#define IRED					0x04
#define BACKLIGHT_TIMEOUT		0x05


//temperature.h
#define TEMPMAXADC				1364		//1402
#define TEMPMINADC				1591		//1617	The lower the ADC value, the higher the temp.
#define TEMPOFFSET				00
#define ROOMTEMPMAXADC			3500		//32 degress fairenheit 3109
#define ROOMTEMPMINADC

/*
#define	NORESULT				0x00
#define FERTILITY_BEGIN			0x01
#define FERTILITY_PREDICT		0x02
#define OVULATION				0x04
#define FERTILITY_END			0x08
*/







#define MAINMENU1				01
#define MAINMENU2				02
#define CUSTOMER				03
#define POWERUP					04
//								05
#define LOWBATT					06
//								07
#define	KEYWAIT					08
//								09
#define MEASUREMENT				10
#define TEMPERATURETOOLOW		11
#define	INPROGRESS				12
#define MEASUREMENTLOWBATTERY	13
#define MEASUREMENTSELECT		14
#define MEASUREMENTMEMORYERROR	15
#define TEMPERATURE				16
#define TEMPERATURENOTVALID		17
#define MEASUREMENTNAMEERROR	18
#define MEASUREMENTNOTVALID		19
#define NAMEPASSWORD			20
//								21
#define NAMEENTRY				22
//								23
#define PASSWORDENTRY			24
//								25
//								26
//								27
//								28
//								29
#define TIMEDATE				30
#define	ALARMERROR				31
#define TIMEENTRY				32
#define PERIODENTRY				33
#define ALARMSET				34
//								35
#define ALARMACTIVE				36
#define DAILY					37
#define ONETIME					38
#define ALARMTYPE				39
#define GRAPH					40
#define CALIBRATE				41
#define DATAPROCESSING			42
#define CALIBRATION_ERROR		43
#define DISPLAYDATA				44
#define pHMEASUREMENT			45
#define CHECKFERTILITY			46
#define MEASURECALIBRATE7		47
#define MEASURECALIBRATE4		48
#define PROGRAMOTHERDATA		49
#define TRANSFERDATA			50
#define RETRIEVINGDATA			51
#define TRANSFERRING			52
#define IREDERROR				53
#define TRANSFERCOMPLETE		54
#define CONNECTED				55
#define HOSTNOTFOUND			56
#define TRANSFERBLANK			57
#define	TRANSFERERROR			58
#define PCFORMATTINGMEMORY		59
#define UNITINFO				60
#define TRANSFERNOSTATUS		61
#define MEASUREMENT4			62
#define	MEASUREMENT7			63
#define	PROBENOTPRESENT			64
#define PROGRAMOTHERDATAERROR	65
#define MEASURECALIBRATE10		66
#define OTHERDATATRANSFERDATA	67
#define OTHERDATAMEASUREMENT	68
#define OTHERDATACALIBRATE		69
#define FORMAT					70
//								71
#define FORMATTING				72
#define OTHERDATACALIBRATEUPDATE 73
//								74
//								75
//								76
//								77
//								78
//								79
#define DIAGNOSTIC				80
#define NOPROFILE				0
#define FERTILITYPROFILE		90
//								91
#define FERTILITYWINDOW			92
#define OVULATING				93
#define FERTILITYTEMPERATUREPROFILE		94
#define OVULATIONEXPECTED		95
//								96
//								97
#define SIGNATURE_MINDAYS_ERROR 98
//								99

/*************FUNCTION PROTOTYPES*************/

//graphics.c
void LCDInit(void);
void FontTable(const unsigned char *, int);
void LCDWrite(unsigned char, unsigned char);
//void LCDWrite68(unsigned char, unsigned char);
void LCDCharDisplay (const unsigned char *);
void LCDSplashScreen (const unsigned char *, int);
void LCDClearDisplay (void);
void LCDMainMenuScreen (const unsigned char *);
void LCDMainMenuScreen2(const unsigned char *);
void LCDTempMeasurementScreen (const unsigned char *);
void LCDMeasurementScreen (const unsigned char *);
void LCDInProgressScreen(const unsigned char *);
void LCDMeasurementCompleteScreen(const unsigned char *);
void LCDTemperatureScreen(const unsigned char *);
void LCDNamePasswordScreen(const unsigned char *);
void LCDNameEntryScreen(const unsigned char *);	
void LCDPasswordEntryScreen(const unsigned char *);
void LCDTimeDateScreen(const unsigned char *);
void LCDTimeDateEntryScreen(const unsigned char *);
void LCDAlarmSetScreen(const unsigned char *);
void LCDGraphScreen(const unsigned char *);
void LCDDataProcessingSelectScreen(const unsigned char *);
void LCDDisplaySavedDataScreen(const unsigned char *);
void LCDCheckFertilityScreen(const unsigned char *);
void LCDTransferDataScreen(const unsigned char *);
void LCDTransferStatusScreen(const unsigned char *,unsigned char,unsigned char);
void LCDUnitInfoScreen(const unsigned char *);
void LCDPrint(unsigned char *, const unsigned char *,unsigned char, unsigned char);
void LCDReset (void);
void LCDPowerUpScreen(const unsigned char *);
void LCDDisplayIcon(const unsigned char *, int);
void LCDClearIcon (void);
void LCDClearLine (unsigned char);
unsigned char LCDRead (unsigned char);
//unsigned char LCDRead68 (unsigned char);
void LCDCursorToggle (unsigned char, unsigned char);
void LCDSetColumn(unsigned char);
void LCDSetCursor(unsigned char, unsigned char);
void LCDPrintCurrentLetter(int, unsigned char *);
void LCDReverseTextUntilTwoBlanks(void);
void LCDUnreverseTextUntilTwoBlanks(void);
void LCDReverseText(unsigned char, unsigned char, unsigned char);
void LCDFormatMemoryScreen(const unsigned char *);
void LCDFormattingMemoryScreen(const unsigned char *);
void LCDMeasurementMemoryErrorScreen(const unsigned char *);
void LCDPrintMeasurement(unsigned int, const unsigned char *, unsigned char, unsigned char, unsigned char);
void LCDPrintpH(unsigned int, const unsigned char *,unsigned char, unsigned char);
void LCDPrintTemperature(unsigned int, unsigned int, const unsigned char *, unsigned char,unsigned char);
void LCDDiagnosticModeScreen(const unsigned char *);
void LCDScreenTest(void);
void LCDAlarmActiveDisplayScreen(const unsigned char *);
void LCDAlarmTypeScreen(const unsigned char *);
void LCDPrintValue(unsigned char, unsigned char *,unsigned char, unsigned char);
void LCDWakeup(void);
unsigned char LCDCustomerScreen(void);
unsigned char LCDCheckForCustomerScreen(void);
void LCDInitCustomerScreen(void);
void LCDDisplaySavedDataIntroScreen(const unsigned char *);
void LCDDisplaySavedDataScreen(const unsigned char *);
void LCDMeasurementLowBatteryScreen(const unsigned char *);
void LCDMeasurementNotEnoughMemoryScreen(const unsigned char *);
void LCDMeasurementNoNameEnteredScreen(const unsigned char *);
void LCDMeasurementNotValidScreen(const unsigned char *);
void LCDTemperatureNotValidScreen(const unsigned char *);
void LCDFertilityTemperatureProfileScreen(const unsigned char *);
void LCDCheckFertilityScreen(const unsigned char *);
void LCDMeasurementProcessingScreen(const unsigned char *);
void LCDMeasurementFertilityWindowScreen(const unsigned char *);
void LCDMeasurementOvulatingScreen(const unsigned char *);
void LCDNoProfileDetectedScreen(const unsigned char *);
void LCDDisplayStatusIcon(unsigned int);
void LCDClearText(unsigned char, unsigned char, unsigned char, unsigned char);
void LCDCodeUpdateScreen(const unsigned char *);
void LCDPrintIntValue(unsigned int, unsigned char *,unsigned char, unsigned char);
void LCDAlarmErrorScreen(unsigned char *);
void LCDPeriodEntryScreen(const unsigned char *);
void LCDPeriodLengthEntryScreen(const unsigned char *);
void LCDPeriodConfirmScreen(const unsigned char *);
void LCDPeriodTodayScreen(const unsigned char *);
void LCDPeriodYesterdayScreen(const unsigned char *);
void LCDPeriodDateScreen(const unsigned char *);
void LCDTemperatureTooLowScreen(const unsigned char *);
unsigned float LCDPrintpHValue(unsigned int, unsigned int, unsigned float);
void LCDPrintpHIndications(unsigned float, const unsigned char *);
void LCDpHScreen(void);
void LCDCalibrationScreen(const unsigned char *);
void LCDCalibrationErrorScreen(const unsigned char *);
#ifdef FACTORYpH
void LCDMeasurementCalibrationPerpHScreen(const unsigned char *, unsigned char);
void LCDFactorypHMeasurementCalibrationErrorScreen(const unsigned char *);
void LCDProbeNotPresentErrorScreen(const unsigned char *);
#endif

//i2c.c
#ifdef FACTORYpH
void PStartFs(void);
void PStopFs(void);
unsigned char WritePI2CDataFs(unsigned char);
unsigned char ReadPI2CDataFs(unsigned char);
void PI2CResetMemory(void);
void PI2CWriteDataAtAddress(unsigned char, unsigned char);
unsigned char PI2CReadDataAtAddress(unsigned char);
void PI2CEnableAVCC(void);
#endif
#ifdef pH
void PStartFs(void);
void PStopFs(void);
unsigned char WritePI2CDataFs(unsigned char);
unsigned char ReadPI2CDataFs(unsigned char);
void PI2CResetMemory(void);
void PI2CWriteDataAtAddress(unsigned char, unsigned char);
unsigned char PI2CReadDataAtAddress(unsigned char);
void PI2CEnableAVCC(void);
#endif

void BitDelayFs(void);
void StartFs(void);
void StopFs(void);
unsigned char WriteI2CDataFs(unsigned char);
unsigned char ReadI2CDataFs(unsigned char);
unsigned char I2CCheckMemoryFormat(void);
void I2CFormatMemory(const unsigned char *);
unsigned char I2CReadMemoryTest(void);
void I2CWriteDataAtAddress(int, unsigned char);
unsigned char I2CReadDataAtAddress(int);

#ifdef pH
unsigned char I2CStoreMeasurementData(unsigned int, unsigned int, unsigned int, unsigned float);
#elif FACTORYpH
unsigned char I2CStoreMeasurementData(unsigned int, unsigned int, unsigned int, unsigned float);
#else
unsigned char I2CStoreMeasurementData(unsigned int, unsigned int, unsigned int);
#endif
void I2CBitDelayFs(void);
void I2CResetMemory(void);
unsigned char I2CRetrieveMemoryData(unsigned int);
unsigned char I2CMemoryTest(void);

//keys.c
unsigned char KeysCheckForKeys (void);
unsigned char KeysMainMenuHandleKeys (const unsigned char *);
unsigned char KeysMeasurementSelectHandleKeys (const unsigned char *);    			
unsigned char KeysMeasurementHandleKeys(const unsigned char *);
unsigned char KeysMeasurementNotValidHandleKeys(unsigned char);
unsigned char KeysNamePasswordHandleKeys(const unsigned char *);
unsigned char KeysNameEntryHandleKeys(const unsigned char *);
unsigned char KeysPasswordEntryHandleKeys(const unsigned char *);
unsigned char KeysTimeDateHandleKeys(const unsigned char *);
unsigned char KeysTimeDateEntryHandleKeys(const unsigned char *);
unsigned char KeysUnitInfoHandleKeys(void);
unsigned char KeysTransferDataHandleKeys(const unsigned char *);
unsigned char KeysAlarmTimeSetHandleKeys(const unsigned char *);
unsigned char KeysFormatMemoryHandleKeys(const unsigned char *);
unsigned char KeysDiagnosticModeHandleKeys(const unsigned char *);
unsigned char KeysAlarmTypeHandleKeys(const unsigned char *);
unsigned char KeysDisplaySavedDataHandleKeys(const unsigned char *);
unsigned char KeysCheckFertilityHandleKeys(const unsigned char *);
unsigned char KeysGraphHandleKeys(void);
unsigned char KeysTemperatureHandleKeys(const unsigned char *);
unsigned char KeysDataProcessingSelectHandleKeys(void);
unsigned char KeysFertilityTemperatureProfileHandleKeys(void);
unsigned char KeysAlarmErrorHandleKeys(void);   
unsigned char KeysPeriodEntryHandleKeys(const unsigned char *);		
unsigned char KeysCalibrateHandleKeys(const unsigned char *);
unsigned char KeyspHMeasurementHandleKeys(const unsigned char *);
#ifdef FACTORYpH
unsigned char KeysMeasureCalibrateHandleKeys(const unsigned char *);
unsigned char KeysMeasurementBufferHandleKeys(const unsigned char *, unsigned char);
unsigned char KeysFactorypHMeasurementHandleKeys (const unsigned char *, unsigned char); 
unsigned char KeysFactorypHProgramOtherDataHandleKeys (const unsigned char *);   			
unsigned char KeysFactorypHProgramOtherDataErrorHandleKeys(const unsigned char *);
#endif

//main.c

//uart.c
void UARTInit(void);
void UARTShutdown(void);
unsigned char WriteUARTData(unsigned char);

//utility.c
void init (void);
void Beep (unsigned char,unsigned int);
void UtilityUpdateTime(void);
void UtilitySetMClk(unsigned char);
unsigned char UtilityGetBatteryLevel(void);
void UtilitySetBatteryLevelADC(void);
void UtilityShutdownADC(void);
void UtilityDelay250ms(unsigned char);
unsigned char UtilityCheckForLowBattery(void);
unsigned char UtilityAlarmActivate(void);
void LCDAlarmActiveDisplayScreen(const unsigned char *);
void UtilityDelay50ms(unsigned char);
void UtilitySoundAlarm(int,int);
void UtilityBeepStart(int);
void UtilityBeepStop(void);
void UtilityCheckForAlarm(void);
void UtilityDelay3Point3us(unsigned char);
void UtilityBacklightController(void);
void UtilityBacklightOn(void);
void UtilityBacklightOff(void);
void UtilityDelay(unsigned int);

//measurement.c
void MeasurementEnableOscillator(const unsigned int);
void MeasurementInitADC(void);
void MeasurementEnable(void);
void MeasurementSetAmplifierGain(unsigned char);
unsigned int MeasurementAcquireData(void);
//void MeasurementRecordData(unsigned int,unsigned int,unsigned int);
void MeasurementDisable(void);
void MeasurementShutdownADC(void);
void MeasurementStop10KHzOscillator(void);
unsigned char MeasurementCheckMemoryForName(void);
unsigned int MeasurementCheckMemoryAvailable(void);
unsigned char MeasurementCheckMeasurements(unsigned int *);
unsigned int MeasurementFinalValue(unsigned int *,unsigned char *);
unsigned char * Measurement30DayProfileCheck(void);
unsigned char MeasurementCheckForSignature(unsigned int *, unsigned char, unsigned char, unsigned int);
unsigned char MeasurementCheckForFertility(unsigned char *);
unsigned char MeasurementCheckpHMeasurements(unsigned float *);
unsigned char MeasurementCheckpHCalibrationMeasurements(unsigned int *);
unsigned float MeasurementFinalpHValue(unsigned float *);
unsigned int MeasurementADCReadpHChannel(unsigned char);

//flash.c
void FlashInit(void);
void FlashEraseA(void);
void FlashWriteA(unsigned char, unsigned char);
unsigned char FlashReadA(unsigned char);
void FlashEraseB(void);
void FlashWriteB(unsigned char, unsigned char);
unsigned char FlashReadB(unsigned char);
void FlashEraseAll(void);
void FlashStoreLCDContrast(void);
void FlashStoreSerialNumber(void);
void FlashROMUpdate(void);
void FlashCheckForOriginalCode(void);
void FlashCheckForGoodCode(void);
void FlashWrite(unsigned char *, unsigned char);
void FlashErase(unsigned char *);
unsigned char FlashRead(unsigned char *);
void FlashSleep(void);
void ROMLCDWrite(unsigned char, unsigned char);

//IrED.c
void IrEDTransmit_01(void);
void IrEDTransmit_00(void);
unsigned char IrEDWriteData(unsigned char);
void IrEDShutdown(void);
void IrEDTransmitInit(void);
void IrEDBitDelay(void);
void IrEDTransmitShutdown(void);
unsigned char IrEDReceiveData(void);
void IrEDReceivePacket(void);
void IrEDTransmitPacket(void);
unsigned char IrEDMessageProcess(void);
unsigned char IrEDCheckForControlEscape(unsigned char);
unsigned char IrEDCheckFrameSequence(void);
unsigned char IrEDCheckConnectionAddress(void);
void IrEDIrLAPXIDResponse(void);
void IrEDIrLAPSNRMResponse(void);
void IrEDIrLAPXIDCommand(void);
void IrEDIRLAPDISCCommand(void);
void IrEDIRLAPSupervisoryFrame(void);
void IrEDIrLMPConnectConfirm(void);
void IrEDIrLAPRRResponse(void);
void IrEDIrLMPInformationAccessService(unsigned char);
void IrEDIrLMPIssueCredit(void);
//unsigned int IrEDUpdateCRC(unsigned char, unsigned int);
//unsigned int IrEDAugmentCRC(unsigned int); 
void IrEDUpdateCRC(unsigned char);
void IrEDAugmentCRC(void);
unsigned int crc16(unsigned char *, unsigned int);


//temperature.c
void TemperatureInitADC(void);
void TemperatureEnable(void);
unsigned int TemperatureAcquireData(void);
void TemperatureDisable(void);
void TemperatureShutdownADC(void);
unsigned char TemperatureCheckForTempSignature(unsigned int *, unsigned char);

//fill.c
void filltomain(void);
